# Annual Research Review: Ecological Momentary Assessment Studies in Child Psychology and Psychiatry

Michael A. Russell, Department of Biobehavioral Health, The Pennsylvania State University

Jamie M. Gajos Department of Human Development and Family Studies, University of Alabama

# Abstract

Background: Enhancements in mobile phone technology allow the study of children and adolescents’ everyday lives like never before. Ecological momentary assessment (EMA) uses these advancements to allow in-depth measurements of links between context, behavior, and physiology in youths’ everyday lives.

Findings: A large and diverse literature now exists on using EMA to study mental and behavioral health among youth. Modern EMA methods are built on a rich tradition of idiographic inquiry focused on the intensive study of individuals. Studies of child and adolescent mental and behavioral health have used EMA to characterize lived experience, document naturalistic within-person processes and individual differences in these processes, measure familiar constructs in novel ways, and examine temporal order and dynamics in youths’ everyday lives.

Conclusions: EMA is feasible and reliable for studying the daily lives of youth. EMA can inform the development and augmentation of traditional and momentary intervention. Continued research and technological development in mobile intervention design and implementation, EMAsensor integration, and complex real-time data analysis are needed to realize the potential of just-in-time adaptive intervention, which may allow researchers to reach high-risk youth with intervention content when and where it is needed most.

# Keywords

E-health; adolescence; school children; mental health; methodology

# Introduction

Children’s lives are a collection of moments, each involving transactions between children and their social and physical environments. These moments are a complex blend of the affective, behavioral, and physiological states of everyone present, along with features and activities of the home, school, or neighborhood. Understanding these moments–including how youth respond to, elicit, and otherwise participate in them–informs our understanding of both typical and atypical developmental trajectories underlying risk for and protection from mental and physical health problems, and may suggest points for intervention.

Ecological momentary assessment (EMA) focuses on the moments of everyday life by capturing brief, repeated assessments in natural environments (Shiffman, Stone, & Hufford, 2008). Traditionally, EMA studies relied exclusively on self-reports, but an increasing number of EMA studies are marrying these self-reports with wearable sensors, such as actigraphy sensors for sleep and accelerometers for physical activity (Trull & Ebner-Priemer, 2013). In EMA, assessments are “ecological” because moods, behaviors, symptoms, and experiences are sampled in the natural environment, offering a high degree of ecological validity relative to laboratory based investigations (Shiffman et al., 2008; Trull & EbnerPriemer, 2013). Assessments are “momentary” in EMA because individuals are sampled frequently and asked to report on events and experiences at the current moment or recalled over short time spans (e.g., the past half-hour). EMA falls under the broader umbrella of ambulatory assessment, a term that encompasses both self-report and sensor-based measurement strategies designed to obtain repeated assessments in participants’ natural environments (Trull & Ebner-Priemer, 2013). As many investigators use the term EMA interchangeably with the terms experience sampling methodology (ESM), daily diary studies, and electronic diary(eDiary) studies, we use EMA to refer to any study that uses paper-and-pencil or mobile electronic devices to collect repeated self-reports in participants’ natural environments, with or without wearable sensors.

# How is EMA employed?

Past EMA studies have used paper-and-pencil diaries, pagers, and personal digital assistants (PDAs); these technologies have been largely replaced by smartphones and tablets (Trull & Ebner-Priemer, 2013), allowing more seamless integration of sensors, such as global positioning system (GPS) sensors, actigraphy monitors for sleep and physical activity, and electrodermal activity (EDA) for physiological arousal via skin conductance (Trull & EbnerPriemer, 2013). EMA studies use intensive sampling schemes generally falling into one of two categories (see Shiffman et al., 2008). Time-based sampling schemes issue prompts at fixed or variable intervals and are often device-initiated, meaning that participants do not initiate surveys—they respond to device-based prompts. In a fixed-interval sampling scheme, participants receive prompts at fixed times aligning with their schedules (e.g., Russell, Wang, & Odgers, 2016). In a variable-interval scheme, participants receive prompts, for example, approximately every 30 minutes, with exact timing of prompts generated at random within this interval so that specific interval times vary and elicit more spontaneous self-reports (e.g., Whalen, Odgers, Reed, & Henker, 2011). Event-based sampling schemes base assessments on events of interest, often instructing participants to initiate reports when the event occurs. Events include consumption of alcohol or other substances (e.g., Miranda et al., 2014; Ross et al., 2018), self-injurious behavior (Kranzler et al., 2018; Nock, Prinstein, & Sterba, 2009), or a social interaction (Koro-Ljungberg, Bussing, Williamson, Wilder, & Mills, 2008).

Many EMA studies have been conducted with children and adolescents, summarized in two recent systematic reviews (Heron, Everhart, McHale, & Smyth, 2017; Wen, Schneider,

Stone, & Spruijt-Metz, 2017). Most EMA studies with children and adolescents have ranged in length from 2 to 42 days, involved two to nine survey prompts daily, used digital technology to collect self-reports, provided monetary incentives to encourage compliance, and trained young participants to operate EMA devices and/or respond to EMA survey questions before going into the field (Heron et al., 2017; Wen et al., 2017). The use of EMA is supported with children and adolescents as young as 7 years of age, as youth of different genders, racial/ethnic groups, nationalities, socioeconomic backgrounds, and mental or physical health conditions all have effectively and compliantly participated in EMA research (Heron et al., 2017). Heron and colleagues (2017) reported average EMA compliance rates–the proportion of prompts to which participants responded–of $7 6 \%$ across their selected studies, which is consistent with the $8 0 \%$ guideline offered in EMA studies with adults (Stone & Shiffman, 2002). Similarly, Wen and colleagues (2017) identified an average compliance rate of $7 8 . 3 \%$ across 42 studies using EMA with youth, noting no significant differences in compliance between clinical and non-clinical samples of youth $7 6 . 9 \%$ versus $7 9 . 2 \%$ , respectively, $p = . 2 9 ,$ ), nor when using EMA with a mobile survey platform only $( 7 7 . 4 \% )$ ) versus a mobile survey platform plus a wearable device $( 7 3 . 0 \%$ , $p$ $= . 3 6 )$ , nor when comparing studies $^ { 2 + }$ weeks in duration versus 1 week or less for both clinical $( p = . 8 5 )$ and non-clinical samples $( p = . 2 7 )$ .

# Why use EMA?

Traditionally, EMA is discussed as offering three general methodological advantages. First, EMA helps to reduce recall bias compared to retrospective self-reports through prospective assessment of symptoms and behaviors soon after they occur, which may be especially important when routine or mundane experiences are being studied (Bradburn, Rips, & Shevell, 1987; Shiffman et al., 2008). Second, EMA offers ecological validity by administering assessments in everyday life, as situations, interactions, and emotions are experienced, which supports inquiry that is relevant to real, everyday life as opposed to the laboratory (Russell & Odgers, in press; Shiffman et al., 2008). Third, EMA enables measurement and modeling of intraindividual or within-person variability, allowing comparisons of a participant to oneself across repeated measures (Bolger, Davis, & Rafaeli, 2003), which facilitate causal inference relative to between-person comparisons because each individual is used as his or her own “control” across time, thus holding constant all characteristics of the individual that are stable during the intensive measurement period (e.g., sex, race/ethnicity, and genotype; Allison, 2005; Rutter, 2005).

In our review of the research literature using EMA to study the everyday lives of children and adolescents, we present a refined list of EMA’s methodological advantages. Specifically, we discuss the following six specific areas in which EMA offers advantages, each falling roughly within one or more of the more general advantages outlined in the previous paragraph. First, EMA allows us to richly characterize the “lived experiences” of youth in their everyday lives through contextually embedded assessments of affect, perceptions, and events. Second, EMA can help elucidate naturalistic, within-person processes, showing the contingencies that describe how symptoms, moods, and behaviors correspond with the shifting situations and contexts of everyday life. Third, through examining within-person processes across multiple individuals, one can learn how these within-person processes

vary between individuals or across contexts (such as home, school, or during free time) through what we are calling process-by-person or process-by-context interactions. Fourth, EMA facilitates novel measurement strategies that go beyond a sole reliance on self-reports. Through repeated measurements of momentary levels and changes in affect, for example, nuanced constructs such as affective lability or negative affective rumination can be estimated without relying on young children and adolescents to provide introspection. Fifth, repeated measurements facilitate examination of bidirectionality in predictor-outcome associations.Thus,we can “unpack” contemporaneous associations between anxiety and sleep, for example, in order to discover which “comes first”, or whether they mutually predict one another in a cyclical fashion, which may have important treatment implications. Sixth, through dense measurement of affect and behaviors over time, EMA allows elucidation of temporal dynamics, permitting nuanced examination of, for example, how and when mood shifts might signal future substance use, and how quickly and for how long negative affect increases after interpersonal conflict.

In the current paper, we review the literature featuring EMA applications in child and adolescent psychology and psychiatry in order to more fully demonstrate these six methodological strengths of EMA. We begin by briefly discussing historical and theoretical traditions informing EMA, highlighting the research tradition emphasizing intensive study of individuals (but note the much more comprehensive historical review of daily life research offered by Wilhelm, Perrez, & Pawlik, 2012). We echo Conner, Tennen, Fleeson, and Barrett’s (2009) description of EMA as a “modern idiographic approach,” and we discuss how it may inform child and adolescent psychology and psychiatry. Next, we review the international body of literature reporting on the use of EMA to examine mental and behavioral health in the day-to-day lives of children and adolescents. Articles for the current review were selected from the references of previously published reviews (Baltasar-Tello, Miguélez-Fernández, Peñuelas-Calvo, & Carballo, 2018; Heron et al., 2017; Wen et al., 2017) and an updated literature search (from December 2017 to January 31, 2019) using PubMed and Google Scholar. Our review is not exhaustive; it is a narrative review in which we provide examples of how EMA may enhance discovery and individualized treatment of mental and behavioral health problems in youth. We discuss studies that used EMA to study mental (e.g., depression, anxiety) or behavioral (e.g., eating, exercise, sleep, substance use) health in clinical or non-clinical samples of children and/or adolescents (age 7 to 25, following Sawyer, Azzopardi, Wickremarathne, and Patton (2018)). Articles were grouped into themes based on the specific methodological strength (of the six identified previously) they most clearly or prominently exemplified. Each theme is discussed below, supported by a review of articles exemplifying the theme across mental and behavioral health outcomes in children and adolescents. Each section finishes with a summary of how research in the theme enhances our understanding of the causes, consequences, and treatment potential of child and adolescent psychopathology. Finally, we conclude with a discussion of future research directions, limitations of EMA with children and adolescents, and concluding remarks.

# Brief History and Ideological Underpinnings of Idiographic Research

The philosophy behind EMA and related ambulatory assessment methods borrows from the idiographic versus nomothetic tradition, first delineated by Wilhelm Windelband (1894/1998). Idiographic refers to research seeking to understand the nuances and idiosyncrasies of individuals, events, or time periods; and nomothetic refers to research seeking to understand general laws and principles that could generalize to a population. Gordon Allport (1937) introduced this distinction to psychologists, suggesting that they adopt idiographic approaches and avoid what was later called the nomothetic or ecological fallacy (Conner, Barrett, Tugade, & Tennen, 2007; Robinson, 1950), committed when one assumes that what is true for the “hypothetical average” individual is true for everyone. Concurrently with Allport’s writing, diaries as research records began to emerge in clinical science (Shiffman et al., 2008), and the idea of research designs sampling random moments from individuals’ daily lives to obtain an “ecology of situations” began to emerge in psychology (Brunswik, 1943). Cattell and colleagues (Cattell, 1943; Cattell, Cattell, & Rhymer, 1947) discussed the use of “temporal sequence studies,” wherein individuals were “measured on a collection of tests on a series of occasions” in order to discover “relative unique traits” that describe regularities across time for each individual (Cattell et al., 1947; p., 267–268).

Thinking from these areas influenced the development of the experience sampling method(ESM) (Hektner, Schmidt,& Csikszentmihalyi, 2Oo7), which offered an early glimpse into modern EMA studies through work assessing adolescents’ activities, moods, and experiences (Csikszentmihalyi, Larson, & Prescott, 1977; Larson, 1989; Larson & Csikszentmihalyi, 1978; Larson, Csikszentmihalyi, & Graef, 1980). Using pagers to signal 25 adolescents at random moments, Csikszentmihalyi and colleagues (1977) documented adolescents’ activities and social contexts, noting that adolescents spent most of their time with peers or engaging in entertainment-related activities. They noted the affective and behavioral correlates associated with various activities and social contexts, showing that NA tended to prevail during activities characterized by socialization into adult roles. Following this, Stone and Shiffman (1994) introduced the term ecological momentary assessment as a direct descendant of ESM and outlining its application to behavioral medicine and related disciplines.

The intensive study of individuals in EMA and other ideographic methodologies necessitates multiple assessments over time. Thus, a central premise underlying idiographic research is that within-person variability, or moment-to-moment change in affect or behavior, is partly “real”–that is, it is not entirely due to measurement error, as might have been assumed previously (Nesselroade & Ram, 2004). While some within-person variability is due to measurement error, some reflects true variability or change over time, including cyclical or oscillatory temporal processes (e.g., diurnal affective cycles) and reversible changes representing situation-behavior associations (Nesselroade & Ram, 2004). Supporting the validity of this viewpoint, methodological developments in multilevel and latent variable modeling demonstrate the parsing of true change from measurement error in intensive longitudinal data (e.g., Nezlek, 2017; Schuurman & Hamaker, 2019); and between-person differences in affective and behavioral reactivity, defined by within-person changes in affect or behavior across situations, add important information for predicting clinical and public health outcomes in adolescents and adults (e.g., Charles, Piazza, Mogle, Sliwinski, & Almeida, 2013; Fuligni, Arruda, Krull, & Gonzales, 2017; C. D. Mohr et al., 2013; Odgers & Russell, 2017; Piazza, Charles, Sliwinski, Mogle, & Almeida, 2013; Russell, Almeida, & Maggs, 2017).

Mischel and colleagues (Mischel, 2004; Mischel & Shoda, 1995; Shoda, Mischel, & Wright, 1994) offer an important example supporting momentary within-person change. This work presents behavioral signatures: “if-then contingencies” between situation and behavior that describe individuals’ behavioral tendencies toward situations in their everyday lives. This idea integrated insights from both “sides” of the person-situation debate, suggesting that the trait-like consistency seen in personality assessments may emerge from one’s characteristic responses to situations (Fleeson, 2004; Mischel, 2004). Shoda et al. (1994) supported this idea in an intensive observational study of youth ages 7–13 visiting summer camp. They identified aggressive behavioral signatures for each child by observing them across situations, which enabled them to discover the presence of stable shifts in aggressive behavior associated with specific situations. Not only was the profile of situationally related aggressive behavior shifts different for each child (e.g., when approached by a peer, some children showed high verbal aggression but others showed low), but behaviors in these situations were stable across time, suggesting that situation-behavior transactions may indeed function as individual characteristics or tendencies (Shoda et al., 1994).

# Review of EMA studies of child and adolescent mental and behavioral health

In this section, we review the international body of research literature applying EMA to study questions relevant to child psychology and psychiatry. Studies are organized according to the six specific themes identified previously.

# Theme 1: Approaching ecological validity: Characterizing the lived experiences of youth with versus without psychopathology

One consistently leveraged feature of EMA studies is their ability to measure lived experience by mapping psychosocial experiences, contexts,and situations as they naturally occur. Through repeated assessments, we can obtain a richly detailed film (versus singleassessment snapshot) of youths’ everyday lives (Shiffman et al., 2008). This richly detailed film offers researchers an assessment of everyday life as experienced as opposed to everyday life as remembered, the latter of which we typically obtain via static retrospective questionnaire assessments (Russell & Odgers, 2015). The repeated, contextually embedded measurement of situations, moods, and behaviors minimizes retrospective recall biases that tend to occur when mundane or routine experiences are recalled over long periods of time (Bradburn et al., 1987; Shiffman et al., 2008) and allows a more accurate picture of what typical day-to-day experience actually “looks and feels like” for youth with versus without mental and behavioral health problems (Russell & Odgers, 2015). Such an approach enables child psychology and psychiatry researchers to discover the psychological and socio-contextual mechanisms that underlie routine symptom experiences in everyday life, potentially opening new avenues to contextually sensitive and situationally embedded treatment solutions.

The work of Carol Whalen, Barbara Henker, and their colleagues demonstrates how EMA can be used to characterize the contexts, behaviors, and symptom experiences of youth with versus without psychopathology (Henker, Whalen, Jamner, & Delfino, 2002; Whalen et al., 2009; Whalen, Henker, Ishikawa, et al., 2006; Whalen, Jamner, Henker, & Delfino, 2001). Whalen, Henker, Jamner, et al. (2006) examined the day-to-day challenges of young adolescents (ages 8–12) with ADHD who were receiving a stable course of stimulant treatment. For one week, EMA reports were obtained via PDAs from parents and children every 30 minutes outside of work and school hours. Results showed that many day-to-day challenges remained present, even when youth with ADHD were receiving a stable course of stimulant medication. In families of children with ADHD, parents reported higher levels of anger when they were with the target child than parents in families of children without ADHD, where the pattern was reversed: higher levels of anger were reported when parents of children without ADHD were not with the target child. Parents of children with ADHD also reported themselves as having lower parenting effectiveness and quality of life. These studies highlighted the interplay between individuals and their environments, outlining the contextual triggers of provocation between parents and children with ADHD; Whalen, Henker, Ishikawa, et al. (2006) noted that transitional activities (such as when parents or children reported “getting ready”) were particularly contentious for children with ADHD and their parents. Further, they documented a negative-affective climate between parents and youth across situations in homes of children with ADHD, showing that maternal reports of anger were more likely to precede, co-occur with, and follow reports of spending time with the child in the homes of children with ADHD (Whalen et al., 2009). These insights illuminated the multifaceted nature of difficulties in families of children with ADHD and evidence of the situations and moods that are more prevalent in ADHD households. Similarly, Henker et al. (2002) examined everyday experiences of adolescents with high, medium, and low levels of anxiety at baseline. Following baseline assessment, youth completed EMA every 30 minutes for two periods of four consecutive days. Youth with high versus low anxiety at baseline showed higher levels of anxiety and stress and higher levels of anger, sadness, and fatigue, providing evidence that the everyday lives of youth with anxiety were characterized not merely by higher levels of anxious or tense affect.

EMA has been used to understand the lives of youth with high-functioning autistic spectrum disorder (ASD), although application of EMA with high-functioning ASD is still in its nascent stages relative to other disorders (but see Chen, Cordier, & Brown, 2015; Cordier, Brown, Chen, Wilkes-Gillan, & Falkmer, 2016; Khor, Gray, Reid, & Melvin, 2014 for examples of this work). Despite the small number of studies in this area, one study by Cordier and colleagues (2016) provides an example of the potential in using EMA to examine the day-to-day social lives of youth with high-functioning ASD. Six Australian boys (aged 8–12) with high-functioning ASD were randomly queried 7 times daily for 7 consecutive days and asked to respond to a series of questions on their current situation (where they were, what they were doing, who they were with), their emotions, and their perceived quality of experiences. These youth reported being in the company of others often $9 0 \%$ of sampling occasions) but reported speaking with others on only $2 5 \%$ of

occasions. When spending time with friends, the youth identified more positive experiences and emotions than when they were with other company, suggesting that time with friends is rewarding to these youth, despite the limited frequency with which it happens. This provided an important nuance in our understanding of the psychosocial experiences of youth with ASD, suggesting that although they do not regularly seek social company, they do find it rewarding.

EMA studies have also investigated adolescents’ exposure to substance use media (Collins et al., 2017; Martino et al., 2016; Scharf, Martino, Setodji, Staplefoote, & Shadel, 2013), which is important given that advertising exposures so routine as to become mundane. As such, these experiences may be ineffectively recalled over long periods of time, suggesting value of EMA. Scharf and colleagues (2013) collected data on alcohol- and tobacco-related exposures among 20 middle- and high-school student via EMA. Seeking to answer questions such as when, how often, where, and with whom adolescents were exposed to substance use media, the authors reported that adolescents reported exposure to alcohol-related media more frequently than tobacco-related media; exposures tended to occur in the afternoon, at point of sale, and on days leading into the weekend; and exposures tended to occur in the presence of family members. A larger study collected self-reports of exposure to alcohol use advertisements as well as appraisals of these advertisements from nearly 600 adolescents aged 11–14, $2 4 \%$ of whom had reported trying at least a sip of alcohol (Collins et al., 2017). Exposure to alcohol advertisements was measured using self-initiated prompts. Adolescents were trained to initiate one of these surveys whenever they encountered an alcohol-related advertisement and provide the particular medium (e.g., TV, radio) and their appraisal of the advertisement. When adolescents saw ads that they appraised positively, they reported more positive attitudes about alcohol than when asked about their alcohol attitudes at random moments, suggesting the influence these advertisements may have on adolescents’ drinking risk.

Other studies have sought to examine adolescents’ everyday experiences with digital media. The ubiquity of digital technology in the everyday lives of youth and concern from the public about its possible detrimental influence on youth development (George & Odgers, 2015) have spawned an emerging body of research using EMA to ascertain whether technology use is associated with mental health problems. Given that technology and media use are relatively routine, researchers have begun to apply EMA to measure the frequency and duration of its use, its affective and social contextual correlates in day-today life, and its downstream associations with mental and physical health (e.g., Bickham, Blood, Walls, Shrier, & Rich, 2013; Bickham, Hswen, & Rich, 2015; George, Russell, Piontak, & Odgers, 2018; Scherer, Bickham, Shrier, & Rich, 2015). Emerging findings from these studies are intriguing and warrant further investigation. For example, Bickham and colleagues (2015) report on a sample of 126 adolescents (ages 13–15 years) who responded to 24-hour retrospective time use diaries and momentary EMA surveys (randomly signaled throughout the day over 2 weeks) focused on the types, duration, and frequency of media use. Higher amounts of television watching and mobile phone use were associated with increased depression at a one-year follow-up, adjusting for baseline depression level. No evidence was found for associations between video games, computer, and music-related media and later depression. Some evidence suggested that parental rules about TV reduce the risk of depression, suggesting that parental regulation over adolescent media use could help mitigate negative relationships.

EMA has also been used to characterize the lived experience of adolescents who drink at risky levels. For example, Kauer and colleagues (2009) reported on work from two samples in Australia: a school-based sample with 18 ninth- and eleventh-grade students and a clinic-based sample of eight high-risk adolescent and young adult drinkers. Using the mobiletype program (see Reid et al., 2009), they documented the social contexts and activities that tended to occur more frequently on drinking versus non-drinking days for school-based youth: less time studying, more time sleeping/resting, and more time “hanging out.” In the clinical sample, they found links between alcohol use and increased negative mood and more time spent with boyfriend/girlfriend on drinking days, but the authors encountered difficulties in assessment: morning diary entries were rarely completed, and when alcohol use was assessed, reports on types and amounts were less complete than with the school-based sample. Similar difficulties were observed in a clinical sample of predominantly Latinx youth $\mathbf { \bar { \rho } } _ { n } = 2 8 $ ) receiving outpatient treatment for substance use in the US. Compliance with EMA reports was high overall (above $8 0 \%$ ) but decreased across the study period and was lower on days when alcohol use was retrospectively reported (Comulada, Lightfoot, Swendeman, Grella, & Wu, 2015). These studies suggest that additional care and tailoring may be necessary before deploying EMA strategies among youth with clinical levels of substance abuse.

Theme 1 summary.—Through repeated, contextually embedded measurement, EMA allows rich characterization of the lived experiences of children and adolescents with versus without psychopathology. Through the minimization of retrospective recall biases that can accompany assessments of routine experiences over long spans of time (Bradburn et al., 1987; Shiffman et al., 2008), EMA offers a more direct measurement of what is truly “typical” for each individual youth with regard to the quality of their environments, symptoms, moods, and behaviors, thereby providing greater accuracy in self-reports of these experiences (Shiffman, 2009) and getting us one step closer to daily life as experienced versus daily life as remembered, compared to retrospective self-reports (Russell & Odgers, 2015). Such an approach will not only facilitate our scientific understanding of day-to-day experience for youth with versus without psychopathology, but may also provide real-world information that can inform optimization of interventions, such as a picture of the family challenges that may remain after a steady course of medication treatment among youth with ADHD, the specific areas in which the social lives of youth with high-functioning ASD may benefit from behavioral intervention, and the specific social and environmental contexts in which adolescents may need to be protected against advertisements promoting substance abuse.

# Theme 2: Naturalistic within-person processes: Symptoms and behaviors as they co-occur with situations and events in everyday life

Many of the theoretical models in research on child and adolescent psychopathology specify naturalistic within-person processes: the contextual and situational conditions under which symptoms may be elevated or decreased compared to what is typical. These models are

concerned with when symptoms or behaviors are expressed, asking questions such as, “Are symptoms of anxiety elevated when adolescents witness interparental conflict, compared to themselves when they do not?” Through EMA, these questions can be answered by comparing adolescents to themselves across time, to see whether change in symptoms or behaviors co-occur with changes in context or situation. Through these within-person comparisons, such an approach uses each adolescent as his or her own control across time, holding constant all stable person-level characteristics, measured or unmeasured. In so doing, researchers can not only identify the scenarios under which problematic symptom change is more likely, but can also take a (small) step toward causal inference regarding the connection between situation and behavior. Studies using EMA to examine within-person processes span several domains in child psychology and psychiatry. Although the studies we review in this section differ considerably with regard to the specific within-person processes they examine, they share the approach of comparing youth to themselves across time and situation to better understand how changes in environments correspond to changes in wellbeing, and they collectively provide a diverse set of examples for how these within-person associations may be informative for both etiological theory and clinical practice.

A small group of EMA studies has focused on within-person processes pertaining to physical activity and eating behaviors among children and adolescents. These health behaviors are notoriously difficult to measure accurately via retrospective reports (de Rezende et al., 2018), making them strong candidates for EMA. An example comes from Toumpakari, Tilling, Haase, and Johnson (2019), who asked 884 adolescents in the UK (ages 11–18) to complete 4-day food diaries via EMA, logging details of their eating occasions and their physical and social contexts. They found that adolescents consumed more high-fat, high-sugar foods when they reported being in “eateries” or at school, compared to when they were “at home,” and more high-fat, high-sugar food with social company than when alone. Similarly, Grenard and colleagues (2013) examined associations between snacking (salty and sweet snacks, sugared beverage consumption) and naturally occurring physical, social, and psychological cues in an EMA study of 158 adolescents (ages 14–17). Adolescents were more likely to engage in unhealthy snacking and/or sweetened beverage consumption when they felt lonely or bored, were with friends, were at school (vs home), were exposed to food cues, and were watching TV.

Seeking to examine the daily life processes linking social environments and eating pathology, Vandewalle, Mabbe, Debeuf, Braet, and Moens (2017) used EMA to measure emotional eating, peer rejection, and parental rejection in 55 normal-weight Belgian adolescents (ages 11–15). Adolescents engaged in significantly more emotional eating on days when they experienced parental rejection than on days they did not. Peer rejection also had a marginally significant influence on emotional eating. Similarly, Ranzenhofer and colleagues (2014) examined affective and interpersonal correlates of loss of control over eating in a sample of 30 adolescent girls ( $M \mathrm { a g e } { = } 1 4 . 9 ,$ ) with overweight/obesity. Momentary ratings of interpersonal problems (e.g., conflict, rejection), affect, and loss of control over eating were measured for two consecutive weeks. Interpersonal problems were associated with increased risk for loss of control over eating at both between- and within-person levels.

The contextual and psychosocial conditions accompanying physical activity have also been studied via EMA, sometimes complemented with data from wearable accelerometers. For example, Dunton and colleagues conducted validation studies of children’s self-reports of physical activity and physical activity contexts collected in their day-to-day lives (Dunton, Intille, Wolch, & Pentz, 2012; Dunton, Liao, Intille, Spruijt-Metz, & Pentz, 2011). Children’s self-reports of vegetation and traffic in their physical activity environments corresponded with those obtained from their parents (Dunton, Intille, et al., 2012), and children’s reports of physical versus sedentary activity corresponded with accelerometer data (Dunton, Liao, Intille, Spruijt-Metz, et al., 2011). This group then investigated the contexts and social company in which youth engage in more physical activity and associations between physical activity and mood level and variability. Evidence suggests that children’s physical activity occurs both outdoors and indoors; accelerometer data indicated that mean steps were greater when youth were outdoors than when they were indoors at home or at someone else’s house (Dunton, Intille, et al., 2012; Dunton, Kawabata, Intille, Wolch, & Pentz, 2012; Dunton, Liao, Intille, Wolch, & Pentz, 2011). Studies also show that neighborhood characteristics, both perceived and objective, are associated with youth physical activity: children engage in more moderate-to-vigorous physical activity (as measured via accelerometry) in settings perceived as having less traffic (Dunton, Intille, et al., 2012).

EMA methods have also been used to examine within-person processes linking psychosocial and contextual factors with suicidal and non-suicidal self-injury (NSSI) thoughts and behaviors among youth (Nock et al., 2009). One study examined day-to-day variation in suicidal ideation among 34 adolescents ( $7 6 \%$ female; ages 13–17) hospitalized due to a last-month suicide attempt (Czyz, Horwitz, Arango, & King, 2019). EMA was administered for four consecutive weeks post-discharge and revealed significant same-day relationships between suicidal ideation ratings and risk factors associated with suicidal ideation. EMA has also clarified the role of daily NA and repetitive negative thinking in predicting NSSI thoughts and behaviors. A community sample of 47 adolescents and young adults (ages 15–21) monitored affective and cognitive states related to risk for NSSI thoughts/behaviors by using an EMA app on a smartphone for 2 weeks (Hughes et al., 2019). Participants were more likely to experience NSSI when reporting higher levels of distress, but only within the context of experiencing high repetitive negative thinking.

EMA studies have also focused on the relationships between shifts in environmental exposures and health behaviors. For example, in a study of 151 youth at risk for early substance use, researchers examined the link between witnessing violence and obesogenic behaviors across 30 consecutive days using mobile phone surveys (Piontak et al., 2017). Compared to days youth did not witness violence, on days they witnessed violence, youth were more likely to consume unhealthy foods and sugar-sweetened beverages, report feeling tiredness the next morning, and, intriguingly, report physical activity. Many of these findings were replicated in a large sample of youth from the southeastern US (replication findings reported in the same study). In a sample of 139 urban, primarily African-American adolescents, Mennis and colleagues (2016) found that a measure of relative disadvantage (difference between the neighborhood disadvantage of home neighborhood vs disadvantage of the space in which their current EMA report was provided), was associated with more perceived stress and less perceived safety (measured via EMA), and average relative disadvantage was associated with more substance use involvement (reported at baseline). Momentary changes in relative disadvantage were strongly associated with momentary perceived stress among adolescents with more baseline substance use, which may reflect the reasons for which such adolescents travel to risky neighborhoods (i.e., to acquire substances).

Intriguingly, studies examining both within- and between-person relationships sometimes find vastly different results across levels of analysis: different results are sometimes found when we compare youth to each other (between-person) versus themselves across time (within-person), providing incentive to guard against the ecological fallacy. Goldschmidt and colleagues (2018) provide an example. They examined the correlates of overeating and loss of control over eating in 40 adolescents aged 8–14 with overweight/obesity in a two-week EMA. Goldschmidt and colleagues (2018) found that when adolescents were compared to themselves across time (within-person), they perceived greater loss of control over eating on occasions with more palatable compared to themselves on occasions with less palatable food. However, when adolescents were compared to each other (between-person), adolescents who tended to perceive food as less palatable showed higher loss of control over eating, on average, showing an opposite relationship to that observed at the within-person level.

Theme 2 summary.—Many hypotheses in child psychology and psychiatry refer to naturalistic within-person processes but fail to test them with designs that can measure them. EMA provides a way to directly test for processes linking contexts, situations, symptoms, and behaviors in everyday life, using each child as his or her own control across time, providing a powerful blend of external and internal validity. Evidence of within-person processes has been seen with regard to eating behaviors, physical activity, self-injury, stress, and substance use, with evidence in some cases showing that the within-person processes do not mirror between-person processes.

# Theme 3: Process-by-person and process-by-context interactions

Another exciting feature of EMA studies is their ability to examine how within-person processes vary between individuals. This allows us to examine not only within-person processes, but also the between-person differences in these within-person processes (e.g., why an association is different for some youth). Between-person differences in these within-person processes can then be explained by several individual, familial, and contextual factors. These process-by-person or process-by-context interactions are central to many theoretical perspectives (Belsky & Pluess, 2009; Del Giudice, Ellis, & Shirtcliff, 2011; Ellis, Boyce, Belsky, Bakermans-Kranenburg, & van Ijzendoorn, 2011; Moffitt, Caspi, & Rutter, 2006; Monroe & Simons, 1991) and are tested in response to some of the most exciting and theoretically nuanced hypotheses about etiology and treatment of psychopathology. Testing these process-by-person/context interactions is possible using EMA and multilevel modeling (MLM).

In a study of 151 adolescents at risk for early substance use in the southwestern US, Russell and colleagues (2016) examined the whether adolescents showed higher odds of antisocial behavior on days they witnessed others using alcohol and drugs versus themselves on days they did not witness others’ substance use. They used MLM with random slopes to test this within-person association, while allowing the model to capture heterogeneity in the direction and strength of this relationship between adolescents. There was an average positive association, such that adolescents were more likely to engage in antisocial behavior on days they witnessed others’ substance use, compared to themselves on non-witnessing days. However, a significant random slope indicated that the relationship was stronger for some adolescents than others, and a genetic marker (DRD4-7R) was introduced as a between-person predictor of the random slope, to test a gene x environment interaction. Adolescents with the 7R allele showed significantly stronger increases in antisocial behavior odds across witnessing versus non-witnessing days than adolescents without the 7R allele, providing evidence of a gene-environment interaction.

In the same sample, Odgers and Russell (2017) examined links between witnessing violence in day-to-day life and experience of mental health problems across 30 consecutive days. Again, using MLM with random slopes, they found that on days adolescents witnessed violence, youth had greater odds of experiencing anger, depressive symptoms, irritability, conduct problems, and other health-risk behavior, compared to themselves on days they did not witness violence. Significant carryover effects were observed: witnessing violence was associated with increased depression and irritability the following day. A person-by-process interaction was also observed, as adolescents who experienced the highest levels of violence exposure showed lower levels of reactivity to violence at the within-person level, providing naturalistic evidence consistent with a violence exposure desensitization process observed in laboratory-based research with youth (Ouellet-Morin et al., 2011).

Allen and colleagues (2016) present a process-by-context interaction in the interaction between parental and child factors in shaping everyday emotional experiences among 106 children with anxiety disorder (ages 9–14). They examined the intersection of parental autonomy granting–tendency toward validation of the child’s perspective and encouragement of independent problem solving–and children’s perceived control over events, via EMA. Child emotional reactivity to negative events and use of emotion regulation strategies in daily life were also assessed; these measures represented withinperson processes linking negative events and emotional experiences. Children with higher perceived control reported less nervousness in response to negative events and used more cognitive restructuring and problem solving strategies to regulate negative emotion. Results showed an interaction between autonomy granting and perceived control: higher autonomy granting was related to more somatic symptoms during negative events and lower likelihood of using acceptance for emotion regulation, but only among youth who had low perceived control. These findings show how within-person associations may vary as a complex interaction of individual- and family-level characteristics, and may help point the way toward effective individualization of treatment strategies.

Returning to physical activity processes, EMA studies have shown evidence that withinperson processes linking children’s perceptions and their physical activity depend on individual, social, and neighborhood characteristics. For example, Salvy, Feda, Epstein, and Roemmich (2017) collected reports of sedentary activities, screen time, and social context using wearable accelerometers to collect physical activity data in the natural environment. Findings suggested a buffering influence of peers against contextual risk on physical activity: youth who reported fewer peer interactions showed less physical activity if they perceived their neighborhoods as less safe; this was not seen among youth who reported more peer interactions.

Theme 3 summary.—By measuring youth intensively across time, EMA facilitatse the discovery of process-by-person interactions: between-person differences in within-person processes that link situations with symptoms and behaviors in everyday life. In this way, we can answer questions such as, “Which youth appear most resilient to affective distress when exposed to violence?” or “In which contexts do youth show the greatest behavioral reactivity to risky situations?” Such questions have a rich theoretical tradition in personality and psychopathology (Belsky & Pluess, 2009; Del Giudice et al., 2011; Ellis et al., 2011; Mischel, 2004; Moffitt et al., 2006; Monroe & Simons, 1991), and answering them may inform tailored intervention strategies for individual youth.

# Theme 4: Novel measurement strategies: Moving beyond a sole reliance on participants’ perceptions

Psychosocial constructs are typically measured and represented with self-report scales. These standard composites rely on participants’ self-awareness about the construct. Although standard composites such as these are used nearly as ubiquitously in EMA as they are in other observational studies, repeated, contextually embedded measurements of these composites allow researchers to create novel and interesting operationalizations without entirely relying on participants’ own self-knowledge. This represents a powerful way to capture complex constructs that participants, especially children and adolescents, may have difficulty introspecting and reporting on.

The construct of affective lability provides a key example. Broadly, affective lability refers to the extent to which a person’s mood levels, positively or negatively valenced, tend to shift away from what is typical for them (their intraindividual mean) or from their immediately previous value (Ram & Gerstorf, 2009). As such, affective lability is distinct from one’s affective intensity, or the level of positive or negative affect being experienced. Using repeated EMA, affective lability can be calculated from data, circumventing the need to ask youth to introspect about how often and how intensively their mood fluctuates. For example, in a study of 79 youth ages 7–17 years with and without MDD, Silk and colleagues (2011) operationalized two dimensions of affective experience using EMA data: affective intensity, or mean level of PA and NA experienced for each adolescent,and affective lability, the standard deviation of PA and NA for each adolescent across EMA reports (i.e., intraindividual standard deviation). Youth with MDD showed greater intensity and lability of NA than those without. Concerning specific affects, youth with MDD showed more intense and labile sadness, anger, and nervousness, suggesting potential deficits in ability to regulate and/or recover from these emotions versus youth without psychopathology.

Other studies have used model-based approaches to estimate affective intensity, lability, and their associations with outcomes. For example, in a study of 119 children ages 9–13 years who completed 8 days of 7-times daily EMA monitoring, Dunton and colleagues (2014) used mixed-effects location-scale modeling to examine associations between moderateto-vigorous physical activity (MVPA; measured via wrist-worn actigraphy sensors) and affective intensity and lability. Mixed-effects location-scale modeling extends MLM to allow simultaneous multivariable modeling of the overall level, between-person heterogeneity, and within-person variability in time-varying outcomes such as affect (Hedeker, Mermelstein, & Demirtas, 2008). Using this technique to analyze temporally dense EMA, Dunton and colleagues (2014) went beyond reporting an association between MVPA and mood, adding that physical activity may stabilize mood, as youth with higher physical activity showed lower variability in PA and NA. Schmeer and colleagues (2019) used mixed-effects locationscale modeling of level and variability parameters to study associations between sleep and family context. They combined survey and EMA data from 1,095 eleven-to-seventeenyear-olds to test the hypothesis that adolescents living in a disadvantaged family context experienced lower average levels and less consistent sleep duration than non-disadvantaged peers. Adolescents who lived in unmarried-parent, low-SES, economically insecure, and high-caregiver-stress families showed greater sleep duration variability across days than adolescents from more economically secure and lower-stress families. Fewer associations were seen between family context and adolescents’ average level of sleep duration, meaning that the association between family context and sleep might have been missed if only traditional measures of sleep duration were used.

Waller and colleagues (2014) present another novel measurement example. Their EMA contained a sequence of questions to capture the complex construct of co-rumination— a pattern of behavior characterized by “extensively discussing and revisiting problems, speculating about problems, and focusing on negative feelings” (Rose, 2002, p. 1830). Co-rumination was considered to be observed if affirmative responses to four questions were seen (Waller et al., 2014, p. 873–874): “Did a negative event with at least ‘a little’ distress occur in the past hour?” (if yes, then) “Were you with a social companion while reacting to the negative event?” (if yes, then) “Did you talk about the negative event with your social companion?” (if yes, then) “Were you unable to stop thinking about how you were feeling?” Using this branching sequence, the researchers found that adolescents (ages 11–17) with MDD engaged in co-rumination with peers roughly 3 times as often, and co-rumination with parents roughly 2 times as often, as youth without diagnoses.

Other studies examining risk processes for adolescent substance use in everyday life have used smartphones to pair GPS technology with EMA self-reports to draw inferences about the social, contextual, and temporal nuances of adolescent problem behavior. For example, EMA via smartphone surveys plus geospatial technology (e.g., GPS and geographic information systems) have spawned a subtechnique called geographic EMA (GEMA; Epstein et al., 2014; Kirchner & Shiffman, 2016), which shows high spatial accuracy and little evidence that adolescent characteristics or neighborhood features are associated with inaccuracy in geographic readings (Mennis, Mason, Ambrus, Way, & Henry, 2017). Using GEMA, Byrnes and colleagues (2017) examined links between spatial context and adolescents’ problem behavior among 170 youth ages 14–16 who completed EMAs on

weekends for a month on GPS-enabled smartphones. GPS-measured density of alcohol outlets was associated with adolescents’ alcohol use measured via EMA, but adolescents’ EMA reports of whether they could observe an alcohol outlet at the current moment were not. These findings suggest that sensor-based measures of physical context may complement self-reports and may enable researchers to detect relationships that cannot be measured through self-reports alone.

Theme 4 summary.—Through creative summaries of repeated assessments, advanced statistical modeling, and technological developments, EMA studies provide novel measurement capabilities that do rely exclusively reliance on youths’ self-awareness of their internal states. The studies discussed in this section are examples of ways in which constructs that may be difficult to measure via self-reports alone influence the development and expression of mental and behavioral health problems in youth.

# Theme 5: The chicken, the egg, or both? Examination of bidirectional relationships

The repeated measurement of EMA studies allows examination of direction in situationsymptom and situation-behavior processes. Often embedded in implicit causal models is a sense of whether the relationship is unidirectional or bidirectional. EMA studies allow examination of bidirectionality, as the timing and temporal precedence of a hypothesized predictor-to-outcome relationship can be revealed.

For some processes of interest, relationships may be inherently bidirectional, with the predictor spurring changes in the outcome and the outcome spurring changes in the predictor. For example, Dunton and colleagues (2014) reported on the bidirectional associations between physical activity, affective dynamics, and physical states. A sample of 120 youth aged 9–13 at risk for overweight or obesity completed self-report smartphone surveys 3–7 times daily, across two four-day spans 6 months apart and wore an actigraph while awake. Feeling more energetic and less tired was associated with increased moderateto-vigorous physical activity in the 30 minutes following an EMA report, and higher physical activity in the 30 minutes before an EMA report was associated with increased levels of PA, higher energy levels, and lower levels of NA. These findings suggested a positive feedback loop connecting momentary well-being and physical activity in youths’ day-to-day lives.

Associations between sleep and affect are also likely to be driven by underlying bidirectional processes, whereby poor sleep may lead to increased NA, and increased NA may lead to poor sleep. Cousins and colleagues (2011) examined the bidirectional processes linking daytime affect and nighttime sleep among youth ages 8–16, hypothesizing that the strength of these relationships might vary between youth with primary MDD $\scriptstyle { \mathtt { m } } = 4 2 $ ), youth with anxiety disorder only $( n { = } 2 3 )$ ), and youth with no psychiatric diagnosis $( \scriptstyle n = 2 9 )$ ). They provide evidence for affect as a mechanism linking mood disorder and sleep disturbances. EMAmeasured affect multiple times daily across two 4-day bursts, and wrist-worn actigraphy provided an estimate of the 24-hour sleep-wake cycle for five consecutive days. In youth with MDD, affect predicted sleep –greater daytime NA was associated with less time awake that night; more daytime PA and higher PA/NA ratios were associated with less time in bed and less total sleep that night. However, affective dimensions did not predict sleep metrics for youth with anxiety disorder only, nor for youth without a psychiatric diagnosis, and higher NA during the day was associated with less time awake the following night for youth with MDD, and more time spent for youth with anxiety disorder. Relationships in which sleep predicted affect also differed by diagnostic groups. For example, longer sleep latency (longer time between going to bed and falling asleep) was associated with less PA and more NA the following day only for youth with MDD.

Sleep has also been tested for bidirectional relationships with cognitive performance and psychopathology symptoms. In a sample of 110 German children (ages 8–11), Könen, Dirk, and Schmiedek (2015) examined the link between self-reported sleep behavior and cognitive performance operationalized using a smartphone-based working memory task. Higher sleep quality the night before was associated with better working memory in the morning, with time in bed showing an inverted U-shaped relationship with working memory performance; performance decrements were seen on nights when adolescents slept less or more than their typical amount. Könen, Dirk, Leonhardt, and Schmiedek (2016) found that higher levels of EMA-measured sleep quality were associated with higher PA the next day, and a bidirectional cycle between affect and sleep was found, such that higher PA in the evening predicted better sleep quality that night. Hennig and colleagues (Hennig, Krkovic, & Lincoln, 2017; Hennig & Lincoln, 2018) examined associations between sleep measured via self-reports and actigraphy measures with various indicators of psychopathology and functioning in a sample of 61 German adolescents aged 14–17. Shorter sleep time (from actigraphy) and more dreaming the night before (from EMA self-reports) were associated with paranoid symptoms reported the next day, but the reverse path was not significant– paranoid symptoms the day before did not predict sleep time (Hennig & Lincoln, 2018). Among the same sample, shorter sleep time via actigraphy predicted higher levels of inattention, whereas other sleep indicators (sensor-based sleep efficiency and wakefulness after sleep onset, EMA self-reported sleep satisfaction, positive affect upon wakening) did not (Hennig et al., 2017).

Theme 5 summary.—Many mental and behavioral health processes are inherently bidirectional; this may be especially true for sleep, physical activity, and substance use, which affect and are affected by multiple psychological and physical factors. Through repeated, temporally intensive measurement, EMA studies allow direct examination of feedback loops in bidirectional processes. Most studies examining bidirectional processes in child and adolescent psychopathology relate to sleep, but many additional applications are possible. A key challenge in this area is temporally aligning EMA items with the timing of the bidirectional process–if EMA items are spaced too closely or too far apart in time, the process will be missed (Hamaker, Ceulemans, Grasman, & Tuerlinckx, 2015). However, if aligned to the specific research question, EMA provides a powerful means to study the nuances of bidirectional relationships.

# Theme 6: Temporal dynamics: Watching the ebb and flow of moods and behaviors in near-real time

EMA allows dense sampling of mood, behavior, and context before, during, and following an event, such as a substance use episode. For example, EMA may allow us to predict a hazardous or dangerous drinking event by noting when key risk factors such as NA or psychopathological symptoms are elevated. Additionally, it may allow us to observe the timing and duration of associated consequences after an event. Such temporally dense information is essential for refining our theoretical models of momentary causal process and developing parameters for timing and tailoring mobile interventions.

In the child and adolescent psychopathology literature, these types of investigations have been used primarily to study substance use. For example, Crooke and colleagues (2013) used EMA in a sample of 41 Australian adolescents (ages 14–17) to collect information on affect before and immediately following drinking episodes. Evidence supported affective dynamics as important for understanding momentary drinking risk. When adolescents drank at “intermediate” levels (5–9 drinks per occasion), differences in PA were seen before and after the drinking event, with PA being lower before drinking and elevated after. When adolescents drank at low (fewer than 5 drinks) or high levels ( $^ { 1 0 + }$ drinks), shifts in PA were not seen before or after drinking events. Similarly,Ross and colleagues (2O18) examined change in PA and NA before versus after marijuana use in naturalistic settings. Overall, NA was higher following marijuana use, but PA was relatively unchanged. Findings differed by motivation for use and levels of cannabis dependence. When marijuana was used to cope with stress, NA was highest following marijuana use but declined rapidly thereafter. PA was elevated following marijuana use only among those with higher levels of cannabis dependence.

Similarly, Miranda and colleagues (2014) applied respondent-initiated EMA with 22 frequently drinking adolescents aged 15–19 using a sophisticated momentary sampling scheme to capture naturalistic drinking episodes and subjective responses to alcohol before and after each drink. Using “begin-drink” and “end-drink” surveys for each drink consumed (a drink-bracketing approach; Piasecki, 2019), adolescents indicated how many minutes had passed since they consumed any of their drink, the beverage type, ounces consumed, subjective intoxication, and affect. Estimated blood alcohol concentration (eBAC) was calculated using standard formulas that show high correlation with actual BAC values (Hustad & Carey, 2005). As eBAC increased, adolescents’ stimulation decreased and sedation and “high” associated with alcohol increased. Compared to findings from adults ages 24–64 $6 1 \%$ alcohol dependent), adolescents showed stronger decreases in stimulation associated with increasing eBAC, suggesting important differences in responsiveness that may indicate a psychobiological mechanism through which alcohol intoxication may impart greater reinforcement to adolescents.

Theme 6 summary.—Although relatively nascent, the use of EMA to establish temporal patterns leading into and out of events represents a powerful approach to refining momentary causal models and informing development of context-sensitive mobile interventions by helping determine exactly when, among whom, and for how long risk is present (Riley et al., 2011). Most applications have been in substance misuse, but potential applications include eating pathology, physical activity, and stress response (see Smyth et al., 2018; Smyth et al., 2007 for examples in adults).

# Future Directions, Limitations, and Conclusion

Our review of the literature highlights themes describing the contributions of EMA to our understanding of the etiology and malleability of child and adolescent mental and behavioral health. Given the recent and sustained interest in EMA and wearable sensor research in behavioral science (Hamaker & Wichers, 2017) and accelerating technological development, the field will likely continue to advance in exciting new ways. Here, we outline three particularly intriguing areas.

# Ecological Momentary Intervention (EMI)

Digital technologies used in EMA studies of youth may facilitate the development of ecological momentary interventions (EMI), whereby intervention content is delivered to individuals in their naturalistic environments (Heron & Smyth, 2010). EMI falls under the umbrella of digital health interventions (Hollis et al., 2017). Digital health intervention is a growing area, with mobile applications targeting mental health among children and adolescents (Grist, Porter, & Stallard, 2017), and several reviews have focused on the evaluation of digital or “mobile health” (mHealth) interventions targeting mental and physical health among youth (e.g., Hollis et al., 2017; Seko, Kidd, Wiljer, & McKenzie, 2014; Turner, Spruijt-Metz, Wen, & Hingle, 2015). These reviews note the promise of digital health interventions, including EMI, providing preliminary evidence for feasibility and acceptability (Hollis et al., 2017; Turner et al., 2015) and noting the potential of these interventions to reach youth who have traditionally been hard to reach.

Evidence for effectiveness of computerized cognitive behavioral therapy to treat depression and anxiety has been found among adolescents and young adults, but the effectiveness of digital health interventions for other pediatric mental health conditions remains unclear (Hollis et al., 2017), and evidence regarding the cost-effectiveness and real-world feasibility of digital health and EMI approaches is needed. Research on EMI in psychology and psychiatry is nascent (Myin-Germeys, Klippel, Steinhart, & Reininghaus, 2016); rigorous evaluations are needed of the efficacy of digitally delivered intervention content, the feasibility of digital intervention approaches to service youth in under-resourced or difficultto-access contexts, and ethical considerations related to the delivery and storage of tailored intervention content and personal health information.

# Deeper and broader integration of sensor technology

Expanding sensor technologies offer potential for more seamless integration with ambulatory self-reports. A trend is emerging trend toward deeper integration of EMA and wearable sensors via passive, context-sensing systems that may assist the development of adaptive assessment and intervention by learning to automatically detect–from self-reported, physiological, geographical, and other ambient contextual cues–moments when assessment or intervention are most beneficial. Embedding sensor technologies into EMA or EMI

may help realize the vision of “just-in-time” interventions, wherein an intervention need is passively sensed and cues delivery of digital intervention content (Nahum-Shani et al., 2017).

Few applications of context-sensing assessment or intervention approaches with children and adolescents exist. The KNOWME network project is a context-aware just-in-time intervention with youth, aimed to decrease sedentary activity in ten overweight Hispanic youth (Spruijt-Metz et al., 2015). KNOWME integrated wearable sensors to detect sedentary activity, an actigraph, and a study-administered smartphone with a “sedentary analyzer” that collected, analyzed, and displayed visualizations of adolescents’ activity and sedentary behavior. Context sensing was used to determine moments when momentary intervention was warranted. When sensors detected that the adolescent reached two hours of consecutive sedentary behavior, the smartphone provided a “MOVE” message and alerted researchers. If the adolescent did not respond to the MOVE message within ten minutes, researchers initiated an SMS message motivational interviewing conversation with the goal of motivating the adolescent to engage in physical activity. Adolescents showed significantly fewer minutes $( p { < } 0 . 1 )$ of sedentary behavior using KNOWME versus a baseline assessment period, and SMS messages were associated with increased physical activity in the following 10 minutes $( p { \mathrm { < } } 0 . 0 1 )$ .

Adolescent and young-adult alcohol abuse is an emerging area for integration of sensor technology and EMA. Sensor technology can measure alcohol intoxication passively through the skin, offering wearable, objective measurement for assessing alcohol intoxication (Barnett, 2015; Sakai, Mikulich-Gilbertson, Long, & Crowley, 2006). One relatively well-known device has been validated against field-standard measures of intoxication, such as breath alcohol concentration (BrAC; Greenfield, Bond, & Kerr, 2015). Approximately $1 \%$ of alcohol consumed is eliminated through the skin, allowing the sensor to calculate a transdermal alcohol concentration, which, compared with EMA self-reports of drinking within an episode, is as an objective “check” against estimated blood alcohol concentration derived from momentary self-reports (see, e.g., Barnett, Meade, & Glynn, 2014). Moreover, because intoxication is measured in real time, researchers can examine dynamic features in the intoxication function over time, (i.e., peak level, area under the curve, instantaneous rates of change), allowing a nuanced characterization of naturalistic alcohol use episodes (Barnett et al., 2015; Clapp, Madden, Mooney, & Dahlquist, 2017). Despite the potential for scientific discovery, careful research is needed to address ethical and feasibility issues with using alcohol sensors in youth at risk.

Ultimately, sensing in ambulatory assessment studies may strive to become entirely passive to maximize just-in-time treatment potential while minimizing participant burden. The emerging field of passive sensing uses sensors that are native to mobile devices to infer traits and behavioral patterns about individuals and features or characteristics of the contexts they inhabit (D. C. Mohr, Zhang, & Schueller, 2017). A benefit of these passive sensing approaches is that the participant carries nothing extra, as opposed to the wearable sensors discussed previously; the sensors are embedded in mobile phones, which are carried habitually by most individuals (Poushter & Castillo, 2019). Passive sensing approaches use smartphones’ native sensing capabilities–including device usage data, microphones, ambient light sensors, and GPS location–to infer context (e.g., crowded noisy bar, private room) and behavior (e.g., physical activity from GPS, sleep/wake times from phone usage) in real time, with the assistance of machine learning (Bishop, 2006). To date, passive sensing approaches have been used primarily with adults. Although passive sensing is costly and will require special data protections, this approach offers unique potential for discovery of the naturalistic processes linking environments, situations, and behaviors in youths’ everyday lives.

# Modeling intensive longitudinal data: Moving beyond the multilevel model

As technological capabilities expand, allowing data to be gathered nearer to real-time, the temporal density of ambulatory assessment data will expand. Passive sensor technologies, GPS sensors, and streamlined mobile survey methods will enable the collection of increasingly intensive longitudinal data, providing challenges and opportunities for data analysis. Such temporally dense data contain information about complex temporal trends, temporal stability and volatility of symptoms and behaviors, and situation-behavior contingencies describing the coupling of symptoms and specific situational experiences in everyday life. These temporal characteristics likely differ for each individual, such that one solution is unlikely to apply to everyone.

MLM–the mainstay for analysis of intensive longitudinal data (including EMA and sensor data) in the social and behavioral sciences–has been successfully estimated temporal dynamics while allowing them to differ between individuals via random effects. Updates to the multilevel model, such as multilevel structural equation modeling and mixed-effects location-scale modeling, offer powerful analytic capabilities (Hedeker et al., 2008; Preacher, Zyphur, & Zhang, 2010). Although flexible and generative, MLM and its extensions are likely to encounter convergence issues when attempting to model both the temporal complexity in increasingly intensive or “big” longitudinal data while also allowing for heterogeneity in estimated parameters at the between-person level. For many intensive longitudinal datasets, especially those involving nearly continuously streaming sensor data, other analytic tools will likely be needed.

Alternative approaches to standard MLM may be able to handle this temporal complexity. Person-specific modeling approaches, typically employed in N-of-1 studies and modeling time series, can be used to estimate temporal and situational dynamics for each individual (Molenaar & Campbell, 2009; Ram, Brose, & Molenaar, 2013; Vieira, McDonald, AraújoSoares, Sniehotta, & Henderson, 2017; Wang, Hamaker, & Bergeman, 2012). Individualized estimates can be summarized and modeled as a function of between-person characteristics (e.g., baseline age, sex) in a two-step approach. Similarly, Bayesian multilevel models with time-series elements may allow simultaneous estimation of temporal complexity and heterogeneity (Depaoli & Clifton, 2015; Hamaker, Asparouhov, Brose, Schmiedek, & Muthén, 2018). Advances in dynamic modeling also offer strategies for handling complexities present in EMA designs, including models that can capture non-linear trends, decaying lag functions across continuous time, and state-space grids defining the dynamic behavior of a two-variable system (Hamaker et al., 2015). The increasing richness of modern ambulatory assessment paradigms makes a number of analytic applications possible, and the increasing intensity with which individuals can be sampled will likely push these modeling innovations forward.

# Limitations and unique considerations of EMA

Despite the power and potential of EMA, it has limitations. First, EMA self-report methods may be challenging among youth with severe psychiatric disorders. Evidence supports EMA feasibility in populations with severe mental disorder (Ben-Zeev, 2012; Wenze & Miller, 2010), but adaptations may be required on a per-study basis. Second, EMA may introduce measurement reactivity–change in behavior and mood through the process of assessment (Shiffman et al., 2008). Reactivity generally only matters when participants show motivation to change (Shiffman et al., 2008), but more research is needed before we can claim an exact understanding measurement reactivity in the context of EMA. Third, EMA studies can be cost-, resource-, and labor-intensive, burdensome to participants; and require a high degree of technological literacy. These issues are especially important when working with marginalized, at-risk, or under-resourced youth (Simonich et al., 2004; Tyler, Olson, & Ray, 2018). Studies may benefit by tailoring assessment protocols to align with day-to-day lives to enhance compliance (Heron et al., 2017; Wen et al., 2017). Moreover, creative incentivization strategies may keep high-risk children and adolescents engaged. These include direct methods (e.g., clearly stated financial contingencies and bonus payments) and more indirect methods—for example, recent work suggests that gamification, defined as “the use of game design elements in non-game contexts” (Deterding, Dixon, Khaled, & Nacke, 2011), is associated with increased quantity and quality of data collected in EMA protocols with adults (Van Berkel, Goncalves, Hosio, & Kostakos, 2017). As the percentage of adolescents with a smartphone increases (Anderson & Jiang, 2018), EMA protocols will need to adapt to capture youths’ attention (Modecki, Goldberg, Ehrenreich, Russell, & Bellmore, 2019; Odgers, 2019).

These limitations notwithstanding, EMA and sensor technologies offer a powerful means of investigating and elucidating affective, contextual, and behavioral experiences in the everyday lives of youth. Through repeated intensive sampling in naturalistic environments, EMA helps reduce recall bias, enhance ecological validity, and articulate a wide variety of affective and behavioral dynamics characterizing the lived experience of children and adolescents. Wearable sensor data on contextual and physiological parameters provides a powerful means to elaborate on, enhance, and validate ambulatory self-reports from EMA. Continued research and technological enhancement related to integrations of EMA and passive context sensing and developments in complex intensive longitudinal data analysis will enable ecological momentary interventions to deliver intervention content to high-risk youth when and where it is needed most.

# Acknowledgments

Support was provided via Award T32 DA017629 from the National Institute on Drug Abuse (to J. M. G.). We are grateful for the assistance of Rachel N. Bomysoad for assistance in document retrieval and reference management. The content is solely the responsibility of the authors and does not necessarily represent the official views of the National Institute on Drug Abuse or the National Institutes of Health.

# Abbreviations.

<html><body><table><tr><td>EMA</td><td>Ecological momentary assessment</td></tr><tr><td>ESM</td><td>Experience sampling method</td></tr><tr><td>PA</td><td>Positive affect</td></tr><tr><td>NA</td><td>Negative affect</td></tr><tr><td>ADHD</td><td>Attention-deficit/hyperactivity disorder</td></tr><tr><td>MDD</td><td>Major depressive disorder</td></tr><tr><td>ASD</td><td>Autism spectrum disorder</td></tr><tr><td>GPS</td><td>Global positioning systems</td></tr><tr><td>GEMA</td><td>Geographic ecological momentary assessment</td></tr><tr><td>EMI</td><td>Ecological momentary intervention</td></tr><tr><td>NSSI</td><td>Non-suicidal self-injury</td></tr><tr><td>BAC</td><td>Blood alcohol concentration</td></tr><tr><td>MLM</td><td>Multilevel modeling</td></tr></table></body></html>

# References

Allen KB, Silk JS, Meller S, Tan PZ, Ladouceur CD, Sheeber LB, . . . Ryan ND (2016). Parental autonomy granting and child perceived control: Effects on the everyday emotional experience of anxious youth. Journal of Child Psychology and Psychiatry, 57(7), 835–842. [PubMed: 26549516]   
Allison PD (2005). Fixed effects regressions for longitudinal data using SAS. Cary, NC: SAS Institute, Inc.   
Allport GW (1937). Personality: A psychological interpretation. New York: Henry Holt.   
Anderson M, & Jiang J (2018). Teens, social media and technology 2018. Washington, DC: Pew Research Center’s Internet.   
Baltasar-Tello I, Miguélez-Fernández C, Peñuelas-Calvo I, & Carballo JJ (2018). Ecological momentary assessment and mood disorders in children and adolescents: A systematic review. Current Psychiatry Reports, 20(8), 66. [PubMed: 30069650]   
Barnett NP (2015). Alcohol sensors and their potential for improving clinical care. Addiction, 110(1), 1–3.   
Barnett NP, Meade E, & Glynn TR (2014). Predictors of detection of alcohol use episodes using a transdermal alcohol sensor. Experimental and Clinical Psychopharmacology, 22(1), 86–96. [PubMed: 24490713]   
Barnett NP, Souza T, Glynn T, Luczak S, Swift R, & Rosen I (2015). The transdermal alcohol sensor macro (TASMAC): A rapid data processing tool for use with the SCRAMx alcohol sensor: 726. Alcoholism: Clinical & Experimental Research, 39, 192A.   
Belsky J, & Pluess M (2009). Beyond diathesis stress: Differential susceptibility to environmental influences. Psychological Bulletin, 135(6), 885–908. [PubMed: 19883141]   
Ben-Zeev D (2012). Mobile technologies in the study, assessment, and treatment of schizophrenia. Schizophrenia Bulletin, 38(3), 384–385. [PubMed: 22234487]   
Bickham DS, Blood EA, Walls CE, Shrier LA, & Rich M (2013). Characteristics of screen media use associated with higher BMI in young adolescents. Pediatrics, 131, 1–7. [PubMed: 23277318]   
Bickham DS, Hswen Y, & Rich M (2015). Media use and depression: Exposure, household rules, and symptoms among young adolescents in the USA. International Journal of Public Health, 60(2), 147–155. [PubMed: 25586816]   
Bishop CM (2006). Pattern recognition and machine learning. New York: Springer.   
Bolger N, Davis A, & Rafaeli E (2003). Diary methods: Capturing life as it is lived. Annual Review of Psychology, 54, 579–616.   
Bradburn NM, Rips LJ, & Shevell SK (1987). Answering autobiographical questions: The impact of memory and inference on surveys. Science, 236(4798), 157–161. [PubMed: 3563494]   
Brunswik E (1943). Organismic achievement and environmental probability. Psychological Review, 50(3), 255–272.   
Byrnes HF, Miller BA, Morrison CN, Wiebe DJ, Woychik M, & Wiehe SE (2017). Association of environmental indicators with teen alcohol use and problem behavior: Teens’ observations vs. objectively-measured indicators. Health & Place, 43, 151–157. [PubMed: 28061392]   
Cattell RB (1943). The description of personality. I. Foundations of trait measurement. Psychological Review, 50(6), 559–594.   
Cattell RB, Cattell AKS, & Rhymer RM (1947). P-technique demonstrated in determining psychophysiological source traits in a normal individual. Psychometrika, 12, 267–288. [PubMed: 18921433]   
Charles ST, Piazza JR, Mogle J, Sliwinski MJ, & Almeida DM (2013). The wear and tear of daily stressors on mental health. Psychological Science, 24, 733–741. [PubMed: 23531486]   
Chen Y-W, Cordier R, & Brown N (2015). A preliminary study on the reliability and validity of using experience sampling method in children with autism spectrum disorders. Developmental Neurorehabilitation, 18(6), 383–389. [PubMed: 24304202]   
Clapp JD, Madden DR, Mooney DD, & Dahlquist KE (2017). Examining the social ecology of a bar-crawl: An exploratory pilot study. PLoS ONE, 12(9), e0185238. [PubMed: 28953932]   
Collins RL, Martino SC, Kovalchik SA, D’Amico EJ, Shadel WG, Becker KM, & Tolpadi A (2017). Exposure to alcohol advertising and adolescents’ drinking beliefs: Role of message interpretation. Health Psychology, 36(9), 890–897. [PubMed: 28639822]   
Comulada WS, Lightfoot M, Swendeman D, Grella C, & Wu N (2015). Compliance to cell phonebased EMA among latino youth in outpatient treatment. Journal of Ethnicity in Substance Abuse, 14(3), 232–250. [PubMed: 26114764]   
Conner TS, Barrett LF, Tugade MM, & Tennen H (2007). Idiographic personality: The theory and practice of experience sampling. In Robins RW, Fraley RC, & Krueger RF (Eds.), Handbook of research methods in personality psychology (pp. 79–96). New York: Guilford Press.   
Conner TS, Tennen H, Fleeson W, & Barrett LF (2009). Experience sampling methods: A modern idiographic approach to personality research. Social and Personality Psychology Compass, 3(3), 292–313. [PubMed: 19898679]   
Cordier R, Brown N, Chen Y-W, Wilkes-Gillan S, & Falkmer T (2016). Piloting the use of experience sampling method to investigate the everyday social experiences of children with Asperger syndrome/high functioning autism. Developmental Neurorehabilitation, 19(2), 103–110. [PubMed: 24840290]   
Cousins JC, Whalen DJ, Dahl RE, Forbes EE, Olino TM, Ryan ND, & Silk JS (2011). The bidirectional association between daytime affect and nighttime sleep in youth with anxiety and depression. Journal of Pediatric Psychology, 36(9), 969–979. [PubMed: 21795377]   
Crooke AH, Reid SC, Kauer SD, McKenzie DP, Hearps SJ, Khor AS, & Forbes AB (2013). Temporal mood changes associated with different levels of adolescent drinking: Using mobile phones and experience sampling methods to explore motivations for adolescent alcohol use. Drug and Alcohol Review, 32(3), 262–268. [PubMed: 23432520]   
Csikszentmihalyi M, Larson R, & Prescott S (1977). Ecology of adolescent activity and experience. Journal of Youth and Adolescence, 6(3), 281–294. [PubMed: 24408457]   
Czyz EK, Horwitz AG, Arango A, & King CA (2019). Short-term change and prediction of suicidal ideation among adolescents: A daily diary study following psychiatric hospitalization. Journal of Child Psychology and Psychiatry, 60(7), 732–741. [PubMed: 30246870]   
de Rezende LFM, Rey-Lopez JP, de Sa TH, Chartres N, Fabbri A, Powell L, . . . Bero L (2018). Reporting bias in the literature on the associations of health-related behaviors and statins with cardiovascular disease and all-cause mortality. PLoS biology, 16(6), e2005761. [PubMed: 29912869]   
Del Giudice M, Ellis BJ, & Shirtcliff EA (2011). The adaptive calibration model of stress responsivity. Neuroscience and Biobehavioral Reviews, 35(7), 1562–1592. [PubMed: 21145350]   
Depaoli S, & Clifton JP (2015). A Bayesian approach to multilevel structural equation modeling with continuous and dichotomous outcomes. Structural Equation Modeling: A Multidisciplinary Journal, 22(3), 327–351.   
Deterding S, Dixon D, Khaled R, & Nacke L (2011). From game design elements to gamefulness: Defining gamification. Paper presented at the Proceedings of the 15th international academic MindTrek conference: Envisioning future media environments.   
Dunton GF, Huh J, Leventhal AM, Riggs N, Hedeker D, Spruijt-Metz D, & Pentz MA (2014). Momentary assessment of affect, physical feeling states, and physical activity in children. Health Psychology, 33(3), 255–263. [PubMed: 23668846]   
Dunton GF, Intille SS, Wolch J, & Pentz MA (2012). Children’s perceptions of physical activity environments captured through ecological momentary assessment: A validation study. Preventive Medicine, 55(2), 119–121. [PubMed: 22659225]   
Dunton GF, Kawabata K, Intille S, Wolch J, & Pentz MA (2012). Assessing the social and physical contexts of children’s leisure-time physical activity: An ecological momentary assessment study. American Journal of Health Promotion, 26(3), 135–142. [PubMed: 22208410]   
Dunton GF, Liao Y, Intille S, Wolch J, & Pentz MA (2011). Physical and social contextual influences on children’s leisure-time physical activity: An ecological momentary assessment study. Journal of Physical Activity and Health, 8(s1), S103–S108. [PubMed: 21350250]   
Dunton GF, Liao Y, Intille SS, Spruijt-Metz D, & Pentz M (2011). Investigating children’s physical activity and sedentary behavior using ecological momentary assessment with mobile phones. Obesity, 19(6), 1205–1212. [PubMed: 21164502]   
Ellis BJ, Boyce WT, Belsky J, Bakermans-Kranenburg MJ, & van Ijzendoorn MH (2011). Differential susceptibility to the environment: An evolutionary-neurodevelopmental theory. Development and Psychopathology, 23(1), 7–28. [PubMed: 21262036]   
Epstein DH, Tyburski M, Craig IM, Phillips KA, Jobes ML, Vahabzadeh M, . . . Preston KL (2014). Real-time tracking of neighborhood surroundings and mood in urban drug misusers: Application of a new method to study behavior in its geographical context. Drug and Alcohol Dependence, 134, 22–29. [PubMed: 24332365]   
Fleeson W (2004). Moving personality beyond the person-situation debate: The challenge and the opportunity of within-person variability. Current Directions in Psychological Science, 13(2), 83– 87.   
Fuligni AJ, Arruda EH, Krull JL, & Gonzales NA (2017). Adolescent sleep duration, variability, and peak levels of achievement and mental health. Child Development, 89, e18–e28. [PubMed: 28129442]   
George MJ, & Odgers CL (2015). Seven fears and the science of how mobile technologies may be influencing adolescents in the digital age. Perspectives on Psychological Science, 10(6), 832–851. [PubMed: 26581738]   
George MJ, Russell MA, Piontak JR, & Odgers CL (2018). Concurrent and subsequent associations between daily digital technology use and high-risk adolescents’ mental health symptoms. Child Development, 89(1), 78–88. [PubMed: 28466466]   
Goldschmidt AB, Smith KE, Crosby RD, Boyd HK, Dougherty E, Engel SG, & Haedt-Matt A (2018). Ecological momentary assessment of maladaptive eating in children and adolescents with overweight or obesity. International Journal of Eating Disorders, 51, 549–557.   
Greenfield TK, Bond J, & Kerr WC (2015). Biomonitoring for improving alcohol consumption surveys: The new gold standard? Alcohol Research: Current Reviews, 36(1), 39–45.   
Grenard JL, Stacy AW, Shiffman S, Baraldi AN, MacKinnon DP, Lockhart G, . . . Koprowski C (2013). Sweetened drink and snacking cues in adolescents. A study using ecological momentary assessment. Appetite, 67, 61–73. [PubMed: 23583312]   
Grist R, Porter J, & Stallard P (2017). Mental health mobile apps for preadolescents and adolescents: A systematic review. Journal of Medical Internet Research, 19(5), e176. [PubMed: 28546138]   
Hamaker EL, Asparouhov T, Brose A, Schmiedek F, & Muthén B (2018). At the frontiers of modeling intensive longitudinal data: Dynamic structural equation models for the affective measurements from the COGITO study. Multivariate Behavioral Research, 53(6), 820–841. [PubMed: 29624092]   
Hamaker EL, Ceulemans E, Grasman R, & Tuerlinckx F (2015). Modeling affect dynamics: State of the art and future challenges. Emotion Review, 7(4), 316–322.   
Hamaker EL, & Wichers M (2017). No time like the present: Discovering the hidden dynamics in intensive longitudinal data. Current Directions in Psychological Science, 26(1), 10–15.   
Hedeker D, Mermelstein RJ, & Demirtas H (2008). An application of a mixed-effects location scale model for analysis of ecological momentary assessment (EMA) data. Biometrics, 64(2), 627–634. [PubMed: 17970819]   
Hektner JM, Schmidt JA, & Csikszentmihalyi M (2007). Experience sampling method: Measuring the quality of everyday life. Thousand Oaks, CA: Sage Publications.   
Henker B, Whalen CK, Jamner LD, & Delfino RJ (2002). Anxiety, affect, and activity in teenagers: Monitoring daily life with electronic diaries. Journal of the American Academy of Child & Adolescent Psychiatry, 41(6), 660–670. [PubMed: 12049440]   
Hennig T, Krkovic K, & Lincoln TM (2017). What predicts inattention in adolescents? An experiencesampling study comparing chronotype, subjective, and objective sleep parameters. Sleep Medicine, 38, 58–63. [PubMed: 29031757]   
Hennig T, & Lincoln TM (2018). Sleeping paranoia away? An actigraphy and experience-sampling study with adolescents. Child Psychiatry & Human Development, 49(1), 63–72. [PubMed: 28451897]   
Heron KE, Everhart RS, McHale SM, & Smyth JM (2017). Using mobile-technology-based ecological momentary assessment (EMA) methods with youth: A systematic review and recommendations. Journal of Pediatric Psychology, 42(10), 1087–1107. [PubMed: 28475765]   
Heron KE, & Smyth JM (2010). Ecological momentary interventions: Incorporating mobile technology into psychosocial and health behaviour treatments. British Journal of Health Psychology, 15(1), 1–39. [PubMed: 19646331]   
Hollis C, Falconer CJ, Martin JL, Whittington C, Stockton S, Glazebrook C, & Davies EB (2017). Annual research review: Digital health interventions for children and young people with mental health problems–a systematic and meta-review. Journal of Child Psychology and Psychiatry, 58(4), 474–503. [PubMed: 27943285]   
Hughes CD, King AM, Kranzler A, Fehling K, Miller A, Lindqvist J, & Selby EA (2019). Anxious and overwhelming affects and repetitive negative thinking as ecological predictors of self-injurious thoughts and behaviors. Cognitive Therapy and Research, 43, 88–101.   
Hustad JT, & Carey KB (2005). Using calculations to estimate blood alcohol concentrations for naturally occurring drinking episodes: A validity study. Journal of Studies on Alcohol, 66(1), 130–138. [PubMed: 15830913]   
Kauer SD, Reid SC, Sanci L, & Patton GC (2009). Investigating the utility of mobile phones for collecting data about adolescent alcohol use and related mood, stress and coping behaviours: Lessons and recommendations. Drug and Alcohol Review, 28(1), 25–30. [PubMed: 19320672]   
Khor AS, Gray KM, Reid SC, & Melvin GA (2014). Feasibility and validity of ecological momentary assessment in adolescents with high-functioning autism and Asperger’s disorder. Journal of Adolescence, 37(1), 37–46. [PubMed: 24331303]   
Kirchner TR, & Shiffman S (2016). Spatio-temporal determinants of mental health and well-being: Advances in geographically-explicit ecological momentary assessment (GEMA). Social Psychiatry and Psychiatric Epidemiology, 51(9), 1211–1223. [PubMed: 27558710]   
Könen T, Dirk J, Leonhardt A, & Schmiedek F (2016). The interplay between sleep behavior and affect in elementary school children’s daily life. Journal of Experimental Child Psychology, 150, 1–15. [PubMed: 27236036]   
Könen T, Dirk J, & Schmiedek F (2015). Cognitive benefits of last night’s sleep: Daily variations in children’s sleep behavior are related to working memory fluctuations. Journal of Child Psychology and Psychiatry, 56(2), 171–182. [PubMed: 25052368]   
Koro-Ljungberg M, Bussing R, Williamson P, Wilder J, & Mills T (2008). African-american teenagers’ stories of attention deficit/hyperactivity disorder. Journal of Child and Family Studies, 17(4), 467– 485.   
Kranzler A, Fehling KB, Lindqvist J, Brillante J, Yuan F, Gao X, . . . Selby EA (2018). An ecological investigation of the emotional context surrounding nonsuicidal self-injurious thoughts and behaviors in adolescents and young adults. Suicide and Life-Threatening Behavior, 48(2), 149–159. [PubMed: 28758704]   
Larson R (1989). Beeping children and adolescents: A method for studying time use and daily experience. Journal of Youth and Adolescence, 18(6), 511–530. [PubMed: 24272123]   
Larson R, & Csikszentmihalyi M (1978). Experiential correlates of time alone in adolescence. Journal of Personality, 46(4), 677–693.   
Larson R, Csikszentmihalyi M, & Graef R (1980). Mood variability and the psychosocial adjustment of adolescents. Journal of Youth and Adolescence, 9(6), 469–490. [PubMed: 24318310]   
Martino SC, Kovalchik SA, Collins RL, Becker KM, Shadel WG, & D’Amico EJ (2016). Ecological momentary assessment of the association between exposure to alcohol advertising and early adolescents’ beliefs about alcohol. Journal of Adolescent Health, 58(1), 85–91.   
Mennis J, Mason M, Ambrus A, Way T, & Henry K (2017). The spatial accuracy of geographic ecological momentary assessment (GEMA): Error and bias due to subject and environmental characteristics. Drug & Alcohol Dependence, 178, 188–193. [PubMed: 28654871]   
Mennis J, Mason M, Light J, Rusby J, Westling E, Way T, . . . Flay B (2016). Does substance use moderate the association of neighborhood disadvantage with perceived stress and safety in the activity spaces of urban youth? Drug & Alcohol Dependence, 165, 288–292. [PubMed: 27372218]   
Miranda R, Monti PM, Ray L, Treloar HR, Reynolds EK, Ramirez J, . . . Tidey J (2014). Characterizing subjective responses to alcohol among adolescent problem drinkers. Journal of Abnormal Psychology, 123(1), 117–129. [PubMed: 24661164]   
Mischel W (2004). Toward an integrative science of the person. Annual Review of Psychology, 55, 1–22.   
Mischel W, & Shoda Y (1995). A cognitive-affective system-theory of personality: Reconceptualizing situations, dispositions, dynamics, and invariance in personality structure. Psychological Review, 102(2), 246–268. [PubMed: 7740090]   
Modecki KL, Goldberg RE, Ehrenreich SE, Russell M, & Bellmore A (2019). The practicalities and perils of ambulatory assessment’s promise: Introduction to a special section. Journal of Research on Adolescence, 29(3), 542–550. [PubMed: 31573766]   
Moffitt TE, Caspi A, & Rutter M (2006). Measured gene-environment interactions in psychopathology concepts, research strategies, and implications for research, intervention, and public understanding of genetics. Perspectives on Psychological Science, 1(1), 5–27. [PubMed: 26151183]   
Mohr CD, Brannan D, Wendt S, Jacobs L, Wright R, & Wang M (2013). Daily mood-drinking slopes as predictors: A new take on drinking motives and related outcomes. Psychology of Addictive Behaviors, 27(4), 944–955. [PubMed: 23647154]   
Mohr DC, Zhang M, & Schueller SM (2017). Personal sensing: Understanding mental health using ubiquitous sensors and machine learning. Annual Review of Clinical Psychology, 13, 23–47.   
Molenaar PC, & Campbell CG (2009). The new person-specific paradigm in psychology. Current Directions in Psychological Science, 18(2), 112–117.   
Monroe SM, & Simons AD (1991). Diathesis-stress theories in the context of life stress research: Implications for the depressive disorders. Psychological Bulletin, 110(3), 406–425. [PubMed: 1758917]   
Myin-Germeys I, Klippel A, Steinhart H, & Reininghaus U (2016). Ecological momentary interventions in psychiatry. Current Opinion in Psychiatry, 29(4), 258–263. [PubMed: 27153125]   
Nahum-Shani I, Smith SN, Spring BJ, Collins LM, Witkiewitz K, Tewari A, & Murphy SA (2017). Just-in-time adaptive interventions (JITAIs) in mobile health: Key components and design principles for ongoing health behavior support. Annals of Behavioral Medicine, 52(6), 446–462.   
Nesselroade JR, & Ram N (2004). Studying intraindividual variability: What we have learned that will help us understand lives in context. Research in Human Development, 1(1/2), 9–29.   
Nezlek JB (2017). A practical guide to understanding reliability in studies of within-person variability. Journal of Research in Personality, 69, 149–155.   
Nock MK, Prinstein MJ, & Sterba SK (2009). Revealing the form and function of self-injurious thoughts and behaviors: A real-time ecological assessment study among adolescents and young adults. Journal of Abnormal Psychology, 118(4), 816–827. [PubMed: 19899851]   
Odgers CL (2019). Why digital tools have not yet revolutionized adolescent health research and what we can do. Journal of Research on Adolescence, 29(3), 675–681. [PubMed: 31573761]   
Odgers CL, & Russell MA (2017). Violence exposure is associated with adolescents’ same-and nextday mental health symptoms. Journal of Child Psychology and Psychiatry, 58(12), 1310–1318. [PubMed: 28703312]   
Ouellet-Morin I, Odgers CL, Danese A, Bowes L, Shakoor S, Papadopoulos AS, . . . Arseneault L (2011). Blunted cortisol responses to stress signal social and behavioral problems among maltreated/bullied 12-year-old children. Biological Psychiatry, 70(11), 1016–1023. [PubMed: 21839988]   
Piasecki TM (2019). Assessment of alcohol use in the natural environment. Alcoholism: Clinical and Experimental Research, 43(4), 564–577.   
Piazza JR, Charles ST, Sliwinski MJ, Mogle J, & Almeida DM (2013). Affective reactivity to daily stressors and long-term risk of reporting a chronic physical health condition. Annals of Behavioral Medicine, 45(1), 110–120. [PubMed: 23080393]   
Piontak JR, Russell MA, Danese A, Copeland WE, Hoyle RH, & Odgers CL (2017). Violence exposure and adolescents’ same-day obesogenic behaviors: New findings and a replication. Social Science & Medicine, 189, 145–151. [PubMed: 28768573]   
Poushter J, & Castillo A (2019). Methodology – Spring 2018 Global Attitudes Survey. Retrieved from https://www.pewresearch.org/global/2019/03/04/u-s-german-relationsmethodology-spring-2018-global-attitudes-survey/   
Preacher KJ, Zyphur MJ, & Zhang Z (2010). A general multilevel SEM framework for assessing multilevel mediation. Psychological Methods, 15, 209–233. [PubMed: 20822249]   
Ram N, Brose A, & Molenaar PC (2013). Dynamic factor analysis: Modeling person-specific process. In Little TD (Ed.), The Oxford handbook of quantitative methods, volume 2: Statistical analysis (pp. 441–457). New York: Oxford University Press.   
Ram N, & Gerstorf D (2009). Time-structured and net intraindividual variability: Tools for examining the development of dynamic characteristics and processes. Psychology and Aging, 24(4), 778– 791. [PubMed: 20025395]   
Ranzenhofer LM, Engel SG, Crosby RD, Anderson M, Vannucci A, Cohen LA, . . . Tanofsky-Kraff M (2014). Using ecological momentary assessment to examine interpersonal and affective predictors of loss of control eating in adolescent girls. International Journal of Eating Disorders, 47(7), 748–757.   
Reid SC, Kauer SD, Dudgeon P, Sanci LA, Shrier LA, & Patton GC (2009). A mobile phone program to track young people’s experiences of mood, stress and coping: Development and testing of the mobiletype program. Social Psychiatry and Psychiatric Epidemiology, 44, 501–507. [PubMed: 19011723]   
Riley WT, Rivera DE, Atienza AA, Nilsen W, Allison SM, & Mermelstein R (2011). Health behavior models in the age of mobile interventions: Are our theories up to the task? Translational Behavioral Medicine, 1(1), 53–71. [PubMed: 21796270]   
Robinson WS (1950). Ecological correlations and the behavior of individuals. American Sociological Review, 15(3), 351–357.   
Rose AJ (2002). Co–rumination in the friendships of girls and boys. Child Development, 73(6), 1830– 1843. [PubMed: 12487497]   
Ross CS, Brooks DR, Aschengrau A, Siegel MB, Weinberg J, & Shrier LA (2018). Positive and negative affect following marijuana use in naturalistic settings: An ecological momentary assessment study. Addictive Behaviors, 76, 61–67. [PubMed: 28756041]   
Russell MA, Almeida DM, & Maggs JL (2017). Stressor-related drinking and future alcohol problems among university students. Psychology of Addictive Behaviors, 31(6), 676–687. [PubMed: 28805407]   
Russell MA, & Odgers CL (2015). Antisocial behavior among children in poverty: Understanding environmental effects in daily life. In Pietz CA & Mattson CA (Eds.), Violent offenders: Understanding and assessment (pp. 19–49). New York: Oxford University Press.   
Russell MA, & Odgers CL (in press). Subjective social status predicts adolescents’ day-to-day mental health and future substance use. Journal of Research on Adolescence.   
Russell MA, Wang L, & Odgers CL (2016). Witnessing substance use increases same-day antisocial behavior among at-risk adolescents: Gene–environment interaction in a 30-day ecological momentary assessment study. Development and Psychopathology, 28, 1441–1456. [PubMed: 26648004]   
Rutter M (2005). Environmentally mediated risks for psychopathology: Research strategies and findings. Journal Of The American Academy Of Child And Adolescent Psychiatry, 44(1), 3–18. [PubMed: 15608539]   
Sakai JT, Mikulich-Gilbertson SK, Long RJ, & Crowley TJ (2006). Validity of transdermal alcohol monitoring: Fixed and self-regulated dosing. Alcoholism: Clinical and Experimental Research, 30(1), 26–33.   
Salvy S, Feda DM, Epstein LH, & Roemmich JN (2017). The social context moderates the relationship between neighborhood safety and adolescents’ activities. Preventive Medicine Reports, 6, 355– 360. [PubMed: 28491489]   
Sawyer SM, Azzopardi PS, Wickremarathne D, & Patton GC (2018). The age of adolescence. The Lancet Child & Adolescent Health, 2(3), 223–228. [PubMed: 30169257]   
Scharf DM, Martino SC, Setodji CM, Staplefoote BL, & Shadel WG (2013). Middle and high school students’ exposure to alcohol-and smoking-related media: A pilot study using ecological momentary assessment. Psychology of Addictive Behaviors, 27(4), 1201–1206. [PubMed: 23772763]   
Scherer EA, Bickham DS, Shrier LA, & Rich M (2015). Evaluating multiple intensively collected media use measures: Validity and reliability of momentary assessments. Communication Methods and Measures, 9(3), 170–187.   
Schmeer KK, Tarrence J, Browning CR, Calder CA, Ford JL, & Boettner B (2019). Family contexts and sleep during adolescence. SSM-Population Health, 7, 100320.   
Schuurman N, & Hamaker E (2019). Measurement error and person-specific reliability in multilevel autoregressive modeling. Psychological Methods, 24(1), 70–91. [PubMed: 30188157]   
Seko Y, Kidd S, Wiljer D, & McKenzie K (2014). Youth mental health interventions via mobile phones: A scoping review. Cyberpsychology, Behavior, and Social Networking, 17(9), 591–602.   
Shiffman S (2009). How many cigarettes did you smoke? Assessing cigarette consumption by global report, time-line follow-back, and ecological momentary assessment. Health Psychology, 28(5), 519–526. [PubMed: 19751076]   
Shiffman S, Stone AA, & Hufford MR (2008). Ecological momentary assessment. Annual Review of Clinical Psychology, 4, 1–32.   
Shoda Y, Mischel W, & Wright JC (1994). Intraindividual stability in the organization and patterning of behavior: Incorporating psychological situations into the idiographic analysis of personality. Journal of Personality and Social Psychology, 67(4), 674–687. [PubMed: 7965613]   
Silk JS, Forbes EE, Whalen DJ, Jakubcak JL, Thompson WK, Ryan ND, . . . Dahl RE (2011). Daily emotional dynamics in depressed youth: A cell phone ecological momentary assessment study. Journal of Experimental Child Psychology, 110(2), 241–257. [PubMed: 21112595]   
Simonich H, Wonderlich S, Crosby R, Smyth JM, Thompson K, Redlin J, . . . Haseltine B (2004). The use of ecological momentary assessment approaches in the study of sexually abused children. Child Abuse & Neglect, 28, 803–809. [PubMed: 15261473]   
Smyth JM, Sliwinski MJ, Zawadzki MJ, Scott SB, Conroy DE, Lanza ST, . . . Stoney CM (2018). Everyday stress response targets in the science of behavior change. Behaviour Research and Therapy, 101, 20–29. [PubMed: 29031538]   
Smyth JM, Wonderlich SA, Heron KE, Sliwinski MJ, Crosby RD, Mitchell JE, & Engel SG (2007). Daily and momentary mood and stress are associated with binge eating and vomiting in bulimia nervosa patients in the natural environment. Journal of Consulting and Clinical Psychology, 75(4), 629–638. [PubMed: 17663616]   
Spruijt-Metz D, Wen CK, O’Reilly G, Li M, Lee S, Emken B, . . . Narayanan S (2015). Innovations in the use of interactive technology to support weight management. Current Obesity Reports, 4(4), 510–519. [PubMed: 26364308]   
Stone AA, & Shiffman S (1994). Ecological momentary assessment (EMA) in behavorial medicine. Annals of Behavioral Medicine, 16, 199–202.   
Stone AA, & Shiffman S (2002). Capturing momentary, self-report data: A proposal for reporting guidelines. Annals of Behavioral Medicine, 24(3), 236–243. [PubMed: 12173681]   
Toumpakari Z, Tilling K, Haase AM, & Johnson L (2019). High-risk environments for eating foods surplus to requirements: A multilevel analysis of adolescents’ non-core food intake in the National Diet and Nutrition Survey (NDNS). Public Health Nutrition, 22(1), 74–84. [PubMed: 30404666]   
Trull TJ, & Ebner-Priemer U (2013). Ambulatory assessment. Annual Review of Clinical Psychology, 9(1), 151–176.   
Turner T, Spruijt-Metz D, Wen CF, & Hingle MD (2015). Prevention and treatment of pediatric obesity using mobile and wireless technologies: A systematic review. Pediatric Obesity, 10(6), 403–409. [PubMed: 25641770]   
Tyler KA, Olson K, & Ray CM (2018). Understanding the link between victimization and alcohol use among homeless youth using ecological momentary assessment. Socius, 4, 1–7.   
Van Berkel N, Goncalves J, Hosio S, & Kostakos V (2017). Gamification of mobile experience sampling improves data quality and quantity. Proceedings of the ACM on Interactive, Mobile, Wearable and Ubiquitous Technologies, 1(3), 107:101–107:121.   
Vandewalle J, Mabbe E, Debeuf T, Braet C, & Moens E (2017). The daily relation between parental rejection and emotional eating in youngsters: A diary study. Frontiers in Psychology, 8, Article 691. [PubMed: 28553239]   
Vieira R, McDonald S, Araújo-Soares V, Sniehotta FF, & Henderson R (2017). Dynamic modelling of n-of-1 data: Powerful and flexible data analytics applied to individualised studies. Health Psychology Review, 11(3), 222–234. [PubMed: 28629262]   
Waller JM, Silk JS, Stone LB, & Dahl RE (2014). Co-rumination and co–problem solving in the daily lives of adolescents with major depressive disorder. Journal of the American Academy of Child and Adolescent Psychiatry, 53(8), 869–878. [PubMed: 25062594]   
Wang LP, Hamaker E, & Bergeman C (2012). Investigating inter-individual differences in short-term intra-individual variability. Psychological Methods, 17(4), 567–581. [PubMed: 22924600]   
Wen CKF, Schneider S, Stone AA, & Spruijt-Metz D (2017). Compliance with mobile ecological momentary assessment protocols in children and adolescents: A systematic review and metaanalysis. Journal of Medical Internet Research, 19(4), e132. [PubMed: 28446418]   
Wenze SJ, & Miller IW (2010). Use of ecological momentary assessment in mood disorders research. Clinical Psychology Review, 30(6), 794–804. [PubMed: 20619520]   
Whalen CK, Henker B, Ishikawa SS, Floro JN, Emmerson NA, Johnston JA, & Swindle R (2009). ADHD and anger contexts: Electronic diary mood reports from mothers and children. Journal of Pediatric Psychology, 34(9), 940–953. [PubMed: 19196851]   
Whalen CK, Henker B, Ishikawa SS, Jamner LD, Floro JN, Johnston JA, & Swindle R (2006). An electronic diary study of contextual triggers and ADHD: Get ready, get set, get mad. Journal Of The American Academy Of Child And Adolescent Psychiatry, 45(2), 166–174. [PubMed: 16429087]   
Whalen CK, Henker B, Jamner LD, Ishikawa SS, Floro JN, Swindle R, . . . Johnston JA (2006). Toward mapping daily challenges of living with ADHD: Maternal and child perspectives using electronic diaries. Journal of Abnormal Child Psychology, 34(1), 115–130. [PubMed: 16463071]   
Whalen CK, Jamner LD, Henker B, & Delfino RJ (2001). Smoking and moods in adolescents with depressive and aggressive dispositions: Evidence from surveys and electronic diaries. Health Psychology, 20(2), 99–111. [PubMed: 11315734]   
Whalen CK, Odgers CL, Reed PL, & Henker B (2011). Dissecting daily distress in mothers of children with ADHD: An electronic diary study. Journal of Family Psychology, 25(3), 402–411. [PubMed: 21517172]   
Wilhelm P, Perrez M, & Pawlik K (2012). Conducting research in daily life: A historical review. In Mehl MR & Conner TS (Eds.), Handbook of research methods for studying daily life (pp. 62–86). New York: Guilford Press.   
Windelband W (1894/1998). History and natural science [reprinted]. Theory & Psychology, 8(1), 5–22.

# Key Points

Ecological momentary assessment (EMA) represents a modern idiographic approach to studying the lived experiences of typically and atypically developing children and adolescents.   
Research supports the feasibility and validity of EMA and wearable sensor measurement among youth with and without psychiatric diagnoses.   
EMA studies facilitate novel measurement and allow investigation of lived experience, naturalistic within-person processes, individual differences, and temporal dynamics.   
Continued research and technological development will foster enhancements in modeling, passive sensing, and ecological momentary interventions – allowing intervention content to be delivered to at-risk youth at the times and places it is needed most.